"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class copyTradingLeader extends sequelize_1.Model{static initModel(e){return copyTradingLeader.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,unique:!0,validate:{notNull:{msg:"userId: User ID is required"}}},displayName:{type:sequelize_1.DataTypes.STRING(100),allowNull:!1,validate:{notEmpty:{msg:"displayName: Display name is required"},len:{args:[2,100],msg:"displayName: Must be between 2 and 100 characters"}}},avatar:{type:sequelize_1.DataTypes.STRING(500),allowNull:!0},bio:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},tradingStyle:{type:sequelize_1.DataTypes.ENUM("SCALPING","DAY_TRADING","SWING","POSITION"),allowNull:!1,defaultValue:"DAY_TRADING"},riskLevel:{type:sequelize_1.DataTypes.ENUM("LOW","MEDIUM","HIGH"),allowNull:!1,defaultValue:"MEDIUM"},profitSharePercent:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:10,validate:{min:{args:[0],msg:"profitSharePercent: Cannot be negative"},max:{args:[50],msg:"profitSharePercent: Cannot exceed 50%"}}},minFollowAmount:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:100,validate:{min:{args:[0],msg:"minFollowAmount: Cannot be negative"}}},maxFollowers:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:100,validate:{min:{args:[1],msg:"maxFollowers: Must be at least 1"}}},status:{type:sequelize_1.DataTypes.ENUM("PENDING","ACTIVE","SUSPENDED","REJECTED","INACTIVE"),allowNull:!1,defaultValue:"PENDING"},isPublic:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0},applicationNote:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},rejectionReason:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},createdAt:{type:sequelize_1.DataTypes.DATE,allowNull:!1,defaultValue:sequelize_1.DataTypes.NOW},updatedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!1,defaultValue:sequelize_1.DataTypes.NOW},deletedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0}},{sequelize:e,modelName:"copyTradingLeader",tableName:"copy_trading_leaders",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]},{name:"copy_trading_leaders_user_id_idx",unique:!0,fields:[{name:"userId"}]},{name:"copy_trading_leaders_status_idx",fields:[{name:"status"}]},{name:"copy_trading_leaders_is_public_idx",fields:[{name:"isPublic"}]}]})}static associate(e){copyTradingLeader.belongsTo(e.user,{foreignKey:"userId",as:"user",onDelete:"CASCADE",onUpdate:"CASCADE"});copyTradingLeader.hasMany(e.copyTradingFollower,{foreignKey:"leaderId",as:"followers",onDelete:"CASCADE",onUpdate:"CASCADE"});copyTradingLeader.hasMany(e.copyTradingTrade,{foreignKey:"leaderId",as:"trades",onDelete:"CASCADE",onUpdate:"CASCADE"});copyTradingLeader.hasMany(e.copyTradingTransaction,{foreignKey:"leaderId",as:"transactions",onDelete:"CASCADE",onUpdate:"CASCADE"});copyTradingLeader.hasMany(e.copyTradingLeaderMarket,{foreignKey:"leaderId",as:"markets",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=copyTradingLeader;