"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize"),console_1=require("@b/utils/console");class aiMarketMaker extends sequelize_1.Model{static initModel(e){return aiMarketMaker.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},marketId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,unique:!0,validate:{notEmpty:{msg:"marketId: Market ID must not be empty"},isUUID:{args:4,msg:"marketId: Must be a valid UUID"}}},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","PAUSED","STOPPED"),allowNull:!1,defaultValue:"STOPPED",validate:{isIn:{args:[["ACTIVE","PAUSED","STOPPED"]],msg:"status: Must be ACTIVE, PAUSED, or STOPPED"}}},targetPrice:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"targetPrice: Must be a valid decimal number"},min:{args:[0],msg:"targetPrice: Must be greater than or equal to 0"}},get(){const e=this.getDataValue("targetPrice");return e?parseFloat(e.toString()):0}},priceRangeLow:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"priceRangeLow: Must be a valid decimal number"},min:{args:[0],msg:"priceRangeLow: Must be greater than or equal to 0"}},get(){const e=this.getDataValue("priceRangeLow");return e?parseFloat(e.toString()):0}},priceRangeHigh:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"priceRangeHigh: Must be a valid decimal number"},min:{args:[0],msg:"priceRangeHigh: Must be greater than or equal to 0"}},get(){const e=this.getDataValue("priceRangeHigh");return e?parseFloat(e.toString()):0}},aggressionLevel:{type:sequelize_1.DataTypes.ENUM("CONSERVATIVE","MODERATE","AGGRESSIVE"),allowNull:!1,defaultValue:"CONSERVATIVE",validate:{isIn:{args:[["CONSERVATIVE","MODERATE","AGGRESSIVE"]],msg:"aggressionLevel: Must be CONSERVATIVE, MODERATE, or AGGRESSIVE"}}},maxDailyVolume:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"maxDailyVolume: Must be a valid decimal number"},min:{args:[0],msg:"maxDailyVolume: Must be greater than or equal to 0"}},get(){const e=this.getDataValue("maxDailyVolume");return e?parseFloat(e.toString()):0}},currentDailyVolume:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"currentDailyVolume: Must be a valid decimal number"},min:{args:[0],msg:"currentDailyVolume: Must be greater than or equal to 0"}},get(){const e=this.getDataValue("currentDailyVolume");return e?parseFloat(e.toString()):0}},volatilityThreshold:{type:sequelize_1.DataTypes.DECIMAL(5,2),allowNull:!1,defaultValue:5,validate:{isDecimal:{msg:"volatilityThreshold: Must be a valid decimal number"},min:{args:[0],msg:"volatilityThreshold: Must be greater than or equal to 0"},max:{args:[100],msg:"volatilityThreshold: Must be less than or equal to 100"}},get(){const e=this.getDataValue("volatilityThreshold");return e?parseFloat(e.toString()):5}},pauseOnHighVolatility:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0},realLiquidityPercent:{type:sequelize_1.DataTypes.DECIMAL(5,2),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"realLiquidityPercent: Must be a valid decimal number"},min:{args:[0],msg:"realLiquidityPercent: Must be at least 0"},max:{args:[100],msg:"realLiquidityPercent: Must be at most 100"}},get(){const e=this.getDataValue("realLiquidityPercent");return e?parseFloat(e.toString()):0}},priceMode:{type:sequelize_1.DataTypes.ENUM("AUTONOMOUS","FOLLOW_EXTERNAL","HYBRID"),allowNull:!1,defaultValue:"AUTONOMOUS",validate:{isIn:{args:[["AUTONOMOUS","FOLLOW_EXTERNAL","HYBRID"]],msg:"priceMode: Must be AUTONOMOUS, FOLLOW_EXTERNAL, or HYBRID"}}},externalSymbol:{type:sequelize_1.DataTypes.STRING(20),allowNull:!0,defaultValue:null,comment:"External symbol to track (e.g., BTC/USDT) when in FOLLOW or HYBRID mode"},correlationStrength:{type:sequelize_1.DataTypes.DECIMAL(5,2),allowNull:!1,defaultValue:50,validate:{isDecimal:{msg:"correlationStrength: Must be a valid decimal number"},min:{args:[0],msg:"correlationStrength: Must be at least 0"},max:{args:[100],msg:"correlationStrength: Must be at most 100"}},get(){const e=this.getDataValue("correlationStrength");return e?parseFloat(e.toString()):50}},marketBias:{type:sequelize_1.DataTypes.ENUM("BULLISH","BEARISH","NEUTRAL"),allowNull:!1,defaultValue:"NEUTRAL",validate:{isIn:{args:[["BULLISH","BEARISH","NEUTRAL"]],msg:"marketBias: Must be BULLISH, BEARISH, or NEUTRAL"}}},biasStrength:{type:sequelize_1.DataTypes.DECIMAL(5,2),allowNull:!1,defaultValue:50,validate:{isDecimal:{msg:"biasStrength: Must be a valid decimal number"},min:{args:[0],msg:"biasStrength: Must be at least 0"},max:{args:[100],msg:"biasStrength: Must be at most 100"}},get(){const e=this.getDataValue("biasStrength");return e?parseFloat(e.toString()):50}},currentPhase:{type:sequelize_1.DataTypes.ENUM("ACCUMULATION","MARKUP","DISTRIBUTION","MARKDOWN"),allowNull:!1,defaultValue:"ACCUMULATION",validate:{isIn:{args:[["ACCUMULATION","MARKUP","DISTRIBUTION","MARKDOWN"]],msg:"currentPhase: Must be ACCUMULATION, MARKUP, DISTRIBUTION, or MARKDOWN"}}},phaseStartedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0,defaultValue:null},nextPhaseChangeAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0,defaultValue:null},phaseTargetPrice:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!0,defaultValue:null,get(){const e=this.getDataValue("phaseTargetPrice");return e?parseFloat(e.toString()):null}},baseVolatility:{type:sequelize_1.DataTypes.DECIMAL(5,2),allowNull:!1,defaultValue:2,validate:{isDecimal:{msg:"baseVolatility: Must be a valid decimal number"},min:{args:[.1],msg:"baseVolatility: Must be at least 0.1"},max:{args:[50],msg:"baseVolatility: Must be at most 50"}},get(){const e=this.getDataValue("baseVolatility");return e?parseFloat(e.toString()):2}},volatilityMultiplier:{type:sequelize_1.DataTypes.DECIMAL(3,2),allowNull:!1,defaultValue:1,validate:{isDecimal:{msg:"volatilityMultiplier: Must be a valid decimal number"},min:{args:[.5],msg:"volatilityMultiplier: Must be at least 0.5"},max:{args:[2],msg:"volatilityMultiplier: Must be at most 2.0"}},get(){const e=this.getDataValue("volatilityMultiplier");return e?parseFloat(e.toString()):1}},momentumDecay:{type:sequelize_1.DataTypes.DECIMAL(4,3),allowNull:!1,defaultValue:.95,validate:{isDecimal:{msg:"momentumDecay: Must be a valid decimal number"},min:{args:[.8],msg:"momentumDecay: Must be at least 0.8"},max:{args:[.999],msg:"momentumDecay: Must be at most 0.999"}},get(){const e=this.getDataValue("momentumDecay");return e?parseFloat(e.toString()):.95}},lastKnownPrice:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!0,defaultValue:null,get(){const e=this.getDataValue("lastKnownPrice");return e?parseFloat(e.toString()):null}},trendMomentum:{type:sequelize_1.DataTypes.DECIMAL(5,4),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"trendMomentum: Must be a valid decimal number"},min:{args:[-1],msg:"trendMomentum: Must be at least -1"},max:{args:[1],msg:"trendMomentum: Must be at most 1"}},get(){const e=this.getDataValue("trendMomentum");return e?parseFloat(e.toString()):0}},lastMomentumUpdate:{type:sequelize_1.DataTypes.DATE,allowNull:!0,defaultValue:null}},{sequelize:e,modelName:"aiMarketMaker",tableName:"ai_market_maker",timestamps:!0,hooks:{beforeValidate:e=>{const a=Number(e.priceRangeLow)||0,t=Number(e.priceRangeHigh)||0,l=Number(e.targetPrice)||0;if(a>0&&t>0&&a>=t)throw new Error("priceRangeLow must be less than priceRangeHigh");if(l>0&&a>0&&l<a)throw new Error("targetPrice must be greater than or equal to priceRangeLow");if(l>0&&t>0&&l>t)throw new Error("targetPrice must be less than or equal to priceRangeHigh")},beforeSave:e=>{const a=Number(e.currentDailyVolume)||0,t=Number(e.maxDailyVolume)||0;t>0&&a>t&&console_1.logger.warn("AI_MM",`currentDailyVolume (${a}) exceeds maxDailyVolume (${t})`)}},indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"aiMarketMakerMarketIdKey",unique:!0,using:"BTREE",fields:[{name:"marketId"}]},{name:"aiMarketMakerStatusIdx",using:"BTREE",fields:[{name:"status"}]}]})}static associate(e){aiMarketMaker.hasOne(e.aiMarketMakerPool,{as:"pool",foreignKey:"marketMakerId",onDelete:"CASCADE",onUpdate:"CASCADE"});aiMarketMaker.hasMany(e.aiBot,{as:"bots",foreignKey:"marketMakerId",onDelete:"CASCADE",onUpdate:"CASCADE"});aiMarketMaker.hasMany(e.aiMarketMakerHistory,{as:"history",foreignKey:"marketMakerId",onDelete:"CASCADE",onUpdate:"CASCADE"});aiMarketMaker.belongsTo(e.ecosystemMarket,{as:"market",foreignKey:"marketId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=aiMarketMaker;