"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class aiBot extends sequelize_1.Model{static initModel(e){return aiBot.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},marketMakerId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notEmpty:{msg:"marketMakerId: Market Maker ID must not be empty"},isUUID:{args:4,msg:"marketMakerId: Must be a valid UUID"}}},name:{type:sequelize_1.DataTypes.STRING(100),allowNull:!1,validate:{notEmpty:{msg:"name: Bot name must not be empty"},len:{args:[1,100],msg:"name: Bot name must be between 1 and 100 characters"}}},personality:{type:sequelize_1.DataTypes.ENUM("SCALPER","SWING","ACCUMULATOR","DISTRIBUTOR","MARKET_MAKER"),allowNull:!1,defaultValue:"SCALPER",validate:{isIn:{args:[["SCALPER","SWING","ACCUMULATOR","DISTRIBUTOR","MARKET_MAKER"]],msg:"personality: Must be a valid bot personality type"}}},riskTolerance:{type:sequelize_1.DataTypes.DECIMAL(3,2),allowNull:!1,defaultValue:.5,validate:{isDecimal:{msg:"riskTolerance: Must be a valid decimal number"},min:{args:[.1],msg:"riskTolerance: Must be at least 0.1"},max:{args:[1],msg:"riskTolerance: Must be at most 1.0"}},get(){const e=this.getDataValue("riskTolerance");return e?parseFloat(e.toString()):.5}},tradeFrequency:{type:sequelize_1.DataTypes.ENUM("HIGH","MEDIUM","LOW"),allowNull:!1,defaultValue:"MEDIUM",validate:{isIn:{args:[["HIGH","MEDIUM","LOW"]],msg:"tradeFrequency: Must be HIGH, MEDIUM, or LOW"}}},avgOrderSize:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"avgOrderSize: Must be a valid decimal number"},min:{args:[0],msg:"avgOrderSize: Must be greater than or equal to 0"}},get(){const e=this.getDataValue("avgOrderSize");return e?parseFloat(e.toString()):0}},orderSizeVariance:{type:sequelize_1.DataTypes.DECIMAL(3,2),allowNull:!1,defaultValue:.2,validate:{isDecimal:{msg:"orderSizeVariance: Must be a valid decimal number"},min:{args:[.1],msg:"orderSizeVariance: Must be at least 0.1 (10%)"},max:{args:[.5],msg:"orderSizeVariance: Must be at most 0.5 (50%)"}},get(){const e=this.getDataValue("orderSizeVariance");return e?parseFloat(e.toString()):.2}},preferredSpread:{type:sequelize_1.DataTypes.DECIMAL(5,4),allowNull:!1,defaultValue:.001,validate:{isDecimal:{msg:"preferredSpread: Must be a valid decimal number"},min:{args:[1e-4],msg:"preferredSpread: Must be at least 0.0001 (0.01%)"},max:{args:[.1],msg:"preferredSpread: Must be at most 0.1 (10%)"}},get(){const e=this.getDataValue("preferredSpread");return e?parseFloat(e.toString()):.001}},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","PAUSED","COOLDOWN"),allowNull:!1,defaultValue:"PAUSED",validate:{isIn:{args:[["ACTIVE","PAUSED","COOLDOWN"]],msg:"status: Must be ACTIVE, PAUSED, or COOLDOWN"}}},lastTradeAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},dailyTradeCount:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,validate:{isInt:{msg:"dailyTradeCount: Must be an integer"},min:{args:[0],msg:"dailyTradeCount: Must be greater than or equal to 0"}}},maxDailyTrades:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:100,validate:{isInt:{msg:"maxDailyTrades: Must be an integer"},min:{args:[1],msg:"maxDailyTrades: Must be at least 1"}}},realTradesExecuted:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,validate:{isInt:{msg:"realTradesExecuted: Must be an integer"},min:{args:[0],msg:"realTradesExecuted: Must be >= 0"}}},profitableTrades:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,validate:{isInt:{msg:"profitableTrades: Must be an integer"},min:{args:[0],msg:"profitableTrades: Must be >= 0"}}},totalRealizedPnL:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("totalRealizedPnL");return e?parseFloat(e.toString()):0}},totalVolume:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("totalVolume");return e?parseFloat(e.toString()):0}},currentPosition:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("currentPosition");return e?parseFloat(e.toString()):0}},avgEntryPrice:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("avgEntryPrice");return e?parseFloat(e.toString()):0}}},{sequelize:e,modelName:"aiBot",tableName:"ai_bot",timestamps:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"aiBotMarketMakerIdIdx",using:"BTREE",fields:[{name:"marketMakerId"}]},{name:"aiBotStatusIdx",using:"BTREE",fields:[{name:"status"}]},{name:"aiBotPersonalityIdx",using:"BTREE",fields:[{name:"personality"}]},{name:"aiBotMarketMakerStatusIdx",using:"BTREE",fields:[{name:"marketMakerId"},{name:"status"}]},{name:"aiBotPnLIdx",using:"BTREE",fields:[{name:"totalRealizedPnL"}]}]})}static associate(e){aiBot.belongsTo(e.aiMarketMaker,{as:"marketMaker",foreignKey:"marketMakerId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=aiBot;