"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class aiInvestment extends sequelize_1.Model{static initModel(e){return aiInvestment.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"}}},planId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"planId: Plan ID cannot be null"}}},durationId:{type:sequelize_1.DataTypes.UUID,allowNull:!0},symbol:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"symbol: Market cannot be empty"}}},type:{type:sequelize_1.DataTypes.ENUM("SPOT","ECO"),allowNull:!1,validate:{isIn:{args:[["SPOT","ECO"]],msg:"type: Must be a valid wallet type"}}},amount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isNumeric:{msg:"amount: Amount must be a number"}}},profit:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,validate:{isNumeric:{msg:"profit: Profit must be a number"}}},result:{type:sequelize_1.DataTypes.ENUM("WIN","LOSS","DRAW"),allowNull:!0},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","COMPLETED","CANCELLED","REJECTED"),allowNull:!1,defaultValue:"ACTIVE",validate:{isIn:{args:[["ACTIVE","COMPLETED","CANCELLED","REJECTED"]],msg:"status: Must be a valid status"}}}},{sequelize:e,modelName:"aiInvestment",tableName:"ai_investment",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"aiInvestmentIdKey",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"aiInvestmentUserIdForeign",using:"BTREE",fields:[{name:"userId"}]},{name:"aiInvestmentPlanIdForeign",using:"BTREE",fields:[{name:"planId"}]},{name:"aiInvestmentDurationIdForeign",using:"BTREE",fields:[{name:"durationId"}]}]})}static associate(e){aiInvestment.belongsTo(e.aiInvestmentPlan,{as:"plan",foreignKey:"planId",onDelete:"CASCADE",onUpdate:"CASCADE"});aiInvestment.belongsTo(e.aiInvestmentDuration,{as:"duration",foreignKey:"durationId",onDelete:"CASCADE",onUpdate:"CASCADE"});aiInvestment.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=aiInvestment;