"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class binaryAiEnginePosition extends sequelize_1.Model{static initModel(e){return binaryAiEnginePosition.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},engineId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notEmpty:{msg:"engineId: Engine ID must not be empty"},isUUID:{args:4,msg:"engineId: Must be a valid UUID"}}},binaryOrderId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,unique:!0,validate:{notEmpty:{msg:"binaryOrderId: Binary Order ID must not be empty"},isUUID:{args:4,msg:"binaryOrderId: Must be a valid UUID"}}},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notEmpty:{msg:"userId: User ID must not be empty"},isUUID:{args:4,msg:"userId: Must be a valid UUID"}}},symbol:{type:sequelize_1.DataTypes.STRING(20),allowNull:!1,validate:{notEmpty:{msg:"symbol: Symbol must not be empty"}}},side:{type:sequelize_1.DataTypes.ENUM("RISE","FALL"),allowNull:!1},amount:{type:sequelize_1.DataTypes.DECIMAL(18,8),allowNull:!1,validate:{isDecimal:{msg:"amount: Must be a valid decimal number"},min:{args:[0],msg:"amount: Must be greater than 0"}},get(){const e=this.getDataValue("amount");return null!==e?parseFloat(e):0}},entryPrice:{type:sequelize_1.DataTypes.DECIMAL(18,8),allowNull:!1,validate:{isDecimal:{msg:"entryPrice: Must be a valid decimal number"},min:{args:[0],msg:"entryPrice: Must be greater than 0"}},get(){const e=this.getDataValue("entryPrice");return null!==e?parseFloat(e):0}},expiryTime:{type:sequelize_1.DataTypes.DATE,allowNull:!1},isDemo:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},userTier:{type:sequelize_1.DataTypes.STRING(20),allowNull:!0},isWhale:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},hasCooldown:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},outcome:{type:sequelize_1.DataTypes.ENUM("PENDING","WIN","LOSS","DRAW"),allowNull:!1,defaultValue:"PENDING"},settledAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},wasManipulated:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},manipulationDetails:{type:sequelize_1.DataTypes.JSON,allowNull:!0}},{sequelize:e,modelName:"binaryAiEnginePosition",tableName:"binary_ai_engine_position",timestamps:!0,indexes:[{fields:["engineId"]},{fields:["binaryOrderId"],unique:!0},{fields:["userId"]},{fields:["expiryTime"]},{fields:["outcome"]},{fields:["isWhale"]},{fields:["userTier"]},{fields:["isDemo"]}]})}static associate(e){binaryAiEnginePosition.belongsTo(e.binaryAiEngine,{foreignKey:"engineId",as:"engine",onDelete:"CASCADE"});e.user&&binaryAiEnginePosition.belongsTo(e.user,{foreignKey:"userId",as:"user"})}}exports.default=binaryAiEnginePosition;