"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class binaryAiEngine extends sequelize_1.Model{static initModel(e){return binaryAiEngine.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},marketMakerId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,unique:!0,validate:{notEmpty:{msg:"marketMakerId: Market Maker ID must not be empty"},isUUID:{args:4,msg:"marketMakerId: Must be a valid UUID"}}},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","PAUSED","STOPPED"),allowNull:!1,defaultValue:"STOPPED"},targetUserWinRate:{type:sequelize_1.DataTypes.DECIMAL(5,4),allowNull:!1,defaultValue:.35,validate:{min:{args:[.25],msg:"targetUserWinRate: Must be at least 0.25"},max:{args:[.45],msg:"targetUserWinRate: Must be at most 0.45"}},get(){const e=this.getDataValue("targetUserWinRate");return null!==e?parseFloat(e):.35}},winRateVariance:{type:sequelize_1.DataTypes.DECIMAL(5,4),allowNull:!1,defaultValue:.05,get(){const e=this.getDataValue("winRateVariance");return null!==e?parseFloat(e):.05}},winRateResetHours:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:24},practiceMode:{type:sequelize_1.DataTypes.ENUM("DISABLED","SAME_AS_LIVE","CUSTOM"),allowNull:!1,defaultValue:"DISABLED"},practiceTargetWinRate:{type:sequelize_1.DataTypes.DECIMAL(5,4),allowNull:!1,defaultValue:.55,get(){const e=this.getDataValue("practiceTargetWinRate");return null!==e?parseFloat(e):.55}},practiceWinRateVariance:{type:sequelize_1.DataTypes.DECIMAL(5,4),allowNull:!1,defaultValue:.1,get(){const e=this.getDataValue("practiceWinRateVariance");return null!==e?parseFloat(e):.1}},optimizationStrategy:{type:sequelize_1.DataTypes.ENUM("CONSERVATIVE","MODERATE","AGGRESSIVE"),allowNull:!1,defaultValue:"MODERATE"},maxPriceAdjustmentPercent:{type:sequelize_1.DataTypes.DECIMAL(7,6),allowNull:!1,defaultValue:.003,get(){const e=this.getDataValue("maxPriceAdjustmentPercent");return null!==e?parseFloat(e):.003}},adjustmentLeadTimeSeconds:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:30},volatilityMaskingEnabled:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0},volatilityNoisePercent:{type:sequelize_1.DataTypes.DECIMAL(7,6),allowNull:!1,defaultValue:.001,get(){const e=this.getDataValue("volatilityNoisePercent");return null!==e?parseFloat(e):.001}},enableUserTiers:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},tierCalculationMethod:{type:sequelize_1.DataTypes.ENUM("VOLUME","DEPOSIT","MANUAL"),allowNull:!1,defaultValue:"VOLUME"},enableBigWinCooldown:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0},bigWinThreshold:{type:sequelize_1.DataTypes.DECIMAL(18,8),allowNull:!1,defaultValue:1e3,get(){const e=this.getDataValue("bigWinThreshold");return null!==e?parseFloat(e):1e3}},cooldownDurationMinutes:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:60},cooldownWinRateReduction:{type:sequelize_1.DataTypes.DECIMAL(5,4),allowNull:!1,defaultValue:.1,get(){const e=this.getDataValue("cooldownWinRateReduction");return null!==e?parseFloat(e):.1}},enableWhaleDetection:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0},whaleThreshold:{type:sequelize_1.DataTypes.DECIMAL(18,8),allowNull:!1,defaultValue:5e3,get(){const e=this.getDataValue("whaleThreshold");return null!==e?parseFloat(e):5e3}},whaleStrategy:{type:sequelize_1.DataTypes.ENUM("REDUCE_EXPOSURE","ALERT_ONLY","FORCE_LOSS"),allowNull:!1,defaultValue:"REDUCE_EXPOSURE"},simulationMode:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},logSimulatedActions:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0},enableExternalCorrelation:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},externalPriceSource:{type:sequelize_1.DataTypes.STRING(50),allowNull:!0},maxDeviationPercent:{type:sequelize_1.DataTypes.DECIMAL(5,4),allowNull:!1,defaultValue:.05,get(){const e=this.getDataValue("maxDeviationPercent");return null!==e?parseFloat(e):.05}},allowedOrderTypes:{type:sequelize_1.DataTypes.JSON,allowNull:!1,defaultValue:["RISE_FALL"]},minPositionForOptimization:{type:sequelize_1.DataTypes.DECIMAL(18,8),allowNull:!1,defaultValue:10,get(){const e=this.getDataValue("minPositionForOptimization");return null!==e?parseFloat(e):10}},maxDailyLoss:{type:sequelize_1.DataTypes.DECIMAL(18,8),allowNull:!1,defaultValue:1e4,get(){const e=this.getDataValue("maxDailyLoss");return null!==e?parseFloat(e):1e4}},maxSingleOrderExposure:{type:sequelize_1.DataTypes.DECIMAL(18,8),allowNull:!1,defaultValue:5e3,get(){const e=this.getDataValue("maxSingleOrderExposure");return null!==e?parseFloat(e):5e3}},currentPeriodWins:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0},currentPeriodLosses:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0},currentPeriodPlatformProfit:{type:sequelize_1.DataTypes.DECIMAL(18,8),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("currentPeriodPlatformProfit");return null!==e?parseFloat(e):0}},lastPeriodResetAt:{type:sequelize_1.DataTypes.DATE,allowNull:!1,defaultValue:sequelize_1.DataTypes.NOW},practicePeriodWins:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0},practicePeriodLosses:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0},lastPracticePeriodResetAt:{type:sequelize_1.DataTypes.DATE,allowNull:!1,defaultValue:sequelize_1.DataTypes.NOW},lastSnapshotId:{type:sequelize_1.DataTypes.UUID,allowNull:!0}},{sequelize:e,modelName:"binaryAiEngine",tableName:"binary_ai_engine",timestamps:!0,indexes:[{fields:["marketMakerId"],unique:!0},{fields:["status"]}]})}static associate(e){binaryAiEngine.belongsTo(e.aiMarketMaker,{foreignKey:"marketMakerId",as:"marketMaker"});binaryAiEngine.hasMany(e.binaryAiEnginePosition,{foreignKey:"engineId",as:"positions",onDelete:"CASCADE"});binaryAiEngine.hasMany(e.binaryAiEngineAction,{foreignKey:"engineId",as:"actions",onDelete:"CASCADE"});binaryAiEngine.hasMany(e.binaryAiEngineDailyStats,{foreignKey:"engineId",as:"dailyStats",onDelete:"CASCADE"});binaryAiEngine.hasMany(e.binaryAiEngineUserTier,{foreignKey:"engineId",as:"userTiers",onDelete:"CASCADE"});binaryAiEngine.hasMany(e.binaryAiEngineUserCooldown,{foreignKey:"engineId",as:"userCooldowns",onDelete:"CASCADE"});binaryAiEngine.hasMany(e.binaryAiEngineSnapshot,{foreignKey:"engineId",as:"snapshots",onDelete:"CASCADE"});binaryAiEngine.hasMany(e.binaryAiEngineSimulation,{foreignKey:"engineId",as:"simulations",onDelete:"CASCADE"});binaryAiEngine.hasMany(e.binaryAiEngineABTest,{foreignKey:"engineId",as:"abTests",onDelete:"CASCADE"});binaryAiEngine.hasMany(e.binaryAiEngineCohort,{foreignKey:"engineId",as:"cohorts",onDelete:"CASCADE"});binaryAiEngine.hasMany(e.binaryAiEngineCorrelationAlert,{foreignKey:"engineId",as:"correlationAlerts",onDelete:"CASCADE"})}}exports.default=binaryAiEngine;