"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class exchangeMarket extends sequelize_1.Model{static initModel(e){return exchangeMarket.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},currency:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"currency: Currency must not be empty"}},comment:"Base currency symbol (e.g., BTC, ETH)"},pair:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"pair: Pair must not be empty"}},comment:"Quote currency symbol (e.g., USDT, USD)"},isTrending:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!0,defaultValue:!1,comment:"Whether this market is currently trending"},isHot:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!0,defaultValue:!1,comment:"Whether this market is marked as hot/popular"},metadata:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,validate:{isJSON(e){try{const t=JSON.parse(e);if("object"!=typeof t||null===t)throw new Error("Metadata must be a valid JSON object.");if("object"!=typeof t.precision)throw new Error("Invalid precision.")}catch(e){throw new Error("Metadata must be a valid JSON object: "+e.message)}}},set(e){this.setDataValue("metadata",JSON.stringify(e))},get(){const e=this.getDataValue("metadata");return e?JSON.parse(e):null},comment:"Additional market configuration and precision settings"},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0,validate:{isBoolean:{msg:"status: Status must be a boolean value"}},comment:"Market availability status (active/inactive)"}},{sequelize:e,modelName:"exchangeMarket",tableName:"exchange_market",timestamps:!1,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"exchangeMarketCurrencyPairKey",unique:!0,using:"BTREE",fields:[{name:"currency"},{name:"pair"}]}]})}static associate(e){}}exports.default=exchangeMarket;