"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class comment extends sequelize_1.Model{static initModel(e){return comment.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1,comment:"Unique identifier for the blog comment"},content:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"content: Content must not be empty"}},comment:"Content/text of the comment"},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}},comment:"ID of the user who posted this comment"},postId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"postId: Post ID cannot be null"},isUUID:{args:4,msg:"postId: Post ID must be a valid UUID"}},comment:"ID of the blog post this comment belongs to"},status:{type:sequelize_1.DataTypes.ENUM("APPROVED","PENDING","REJECTED"),defaultValue:"PENDING",allowNull:!1,comment:"Moderation status of the comment (APPROVED, PENDING, REJECTED)"}},{sequelize:e,modelName:"comment",tableName:"comment",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"commentsPostIdForeign",using:"BTREE",fields:[{name:"postId"}]},{name:"commentsUserIdForeign",using:"BTREE",fields:[{name:"userId"}]}]})}static associate(e){comment.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});comment.belongsTo(e.post,{as:"post",foreignKey:"postId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=comment;